﻿//●
//処理：１つのクッキー･データを設定する
//作成：2006.09.26？ by T.A.
//編集：2022.02.07 by T.A.
//呼出：SetCookie(Name,Value,Expires,Path,Domain,Secure)
//引数：Name=クッキー名(半角英数)。
//	Value=クッキー･データ(任意の文字列。半角英数～漢字)。
//	Expires=クッキーの有効期限(日付)。省くと、期限はブラウザを閉じるまで。
//	Path=パス。例="/tetuya630213"など。
//	Domain=ドメイン名。例="blog.livedoor.jp"など。
//	Secure= true=セキュリティの保たれた環境でなければアクセスできないようにする。←→false。
function SetCookie(Name,Value,Expires,Path,Domain,Secure){
 let D=new Date(Expires);
 var S=Name+"="+encodeURIComponent(Value)
 	+(Expires ? "; expires="+D.toUTCString() : "")
 	+(Path ? "; path="+Path : "")
 	+(Domain ? "; domain="+Domain : "")
 	+(Secure ? "; secure" : "");
 document.cookie=S;
}
//●
//処理：１つのクッキー･データを得る
//編集：2006.10.22 by T.A.
//呼出：変数=GetCookie(Name)
//引数：Name=クッキー名。省くと全て取得。
function GetCookie(Name){
 if(!Name)return unescape(document.cookie);
 var CNP=Name+"=";
 var C=document.cookie;
 var SF=C.indexOf(CNP);
 if (SF==-1)return "";	//クッキーが見つからない。又はデータが""の為にクッキー名のみになっている。
 var SF2=C.indexOf(";",SF+CNP.length);
 if (SF2==-1)SF2=C.length;	//データが1個の場合、｢;｣は無い。
 return unescape(C.substring(SF+CNP.length,SF2));
}

//●
//処理：１つのクッキー･データを削除する
//編集：2006.09.26 by T.A.
//呼出：変数=DeleteCookie(Name,Path,Domain)
//引数：Name=クッキー名。
//	Path=パス。例="/tetuya630213"など。
//	Domain=ドメイン名。例="blog.livedoor.jp"など。
function DeleteCookie(Name,Path,Domain){
 if(GetCookie(Name))document.cookie=Name+"="
 	+(Path?"; path="+Path:"")
 	+(Domain?"; domain="+Domain:"")
 	+"; expires="+new Date(0).toGMTString();	//過去の日付
}

